/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.progress;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiProgressBarHandler<T extends IComponentHarness>
implements IScreenAddonProvider,
IContainerAddonProvider,
IComponentHandler {
    private final List<ProgressBarComponent<T>> progressBarComponents = new ArrayList<ProgressBarComponent<T>>();

    @Override
    public void add(Object ... components) {
        Arrays.stream(components).filter(this::accepts).forEach(o -> this.progressBarComponents.add((ProgressBarComponent)o));
    }

    public void update() {
        for (ProgressBarComponent<T> posWorkBar : this.progressBarComponents) {
            if (posWorkBar.getCanIncrease().test(posWorkBar.getComponentHarness())) {
                if (posWorkBar.getIncreaseType() && posWorkBar.getProgress() == 0) {
                    posWorkBar.onStart();
                }
                if (!posWorkBar.getIncreaseType() && posWorkBar.getProgress() == posWorkBar.getMaxProgress()) {
                    posWorkBar.onStart();
                }
                posWorkBar.tickBar();
                continue;
            }
            if (!posWorkBar.getCanReset().test(posWorkBar.getComponentHarness())) continue;
            posWorkBar.setProgress(posWorkBar.getIncreaseType() ? 0 : posWorkBar.getMaxProgress());
        }
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        for (ProgressBarComponent<T> progressBarComponent : this.progressBarComponents) {
            list.addAll(progressBarComponent.getScreenAddons());
        }
        return list;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> list = new ArrayList<IFactory<? extends IContainerAddon>>();
        for (ProgressBarComponent<T> progressBarComponent : this.progressBarComponents) {
            list.addAll(progressBarComponent.getContainerAddons());
        }
        return list;
    }

    private boolean accepts(Object component) {
        return component instanceof ProgressBarComponent;
    }
}

